 ; Ŀ
 ;   Shield - insert a shield block.                                       
 ;   Copyright 2005, 2010 by Rocket Software Ltd.                          
 ;   Caution: doesn't work properly with scaled or rotated terminals.      
 ;   (The code is only about half ready for this.)                         
 ; 
 (DEFUN C:SHIELD (/ osmo clay *error* pa enam entt blnam blint bang bscal p0
                                                                    p1 ss len)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setq clay (getvar "clayer"))
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (setvar "clayer" clay)
   (command "undo" "end")
  (princ))
 ; Ŀ
 ;   Call Malaya to set up the Misc Layer.                                 
 ; 
  (if c:malaya (malaya "misc"))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get a point.                                                          
 ; 
  (setq pa (getpoint "Shield Insertion: "))
  (if (and (setq enam (caar (reverse (nentselp pa))))
           (setq entt (entget enam))
           (setq blnam (strcase (cdr (assoc 2 entt)) t))
           (member blnam '("jb-terminal" "fieldterminal")))
 ; Ŀ
 ;   If there is a terminal block there.                                   
 ; 
      (progn
           (setq blint (cdr (assoc 10 entt)))
           (setq bang (cdr (assoc 50 entt)))
           (setq bscal (cdr (assoc 41 entt)))
 ; Ŀ
 ;   If the block was a Jb-Terminal:                                       
 ; 
           (if (= blnam "jb-terminal")
               (progn
                    (if (> (car pa) (car blint))
                        (progn
                             (setq dirr "r")
                             (setq pa (polar blint bang (* bscal 12.5))))
                        (progn
                             (setq dirr "l")
                             (setq bang (+ bang pi))
                             (setq pa (polar blint bang (* bscal 12.5))))))
 ; Ŀ
 ;   Otherwise it must be a FieldTerminal:                                 
 ; 
               (progn
                    (if (> (car pa) (car blint))
                        (progn
                             (setq dirr "r")
                             (setq pa (polar blint bang (* bscal 5))))
                        (progn
                             (setq dirr "l")
                             (setq bang (+ bang pi))
                             (setq pa (polar blint bang (* bscal 5)))))))
 ; Ŀ
 ;   Count the number of lines in the vicinity.                            
 ; 
           (setq p0 (polar (polar pa bang 5) (/ pi 2) 4))
           (setq p1 (polar (polar p0 (/ pi 2) 12) bang (* bscal 2.5)))
           (if (setq ss (ssget "c" p0 p1 '((-4 . "<or") (0 . "polyline")
                             (0 . "lwpolyline") (0 . "line") (-4 . "or>"))))
               (setq len (sslength ss)))
 ; Ŀ
 ;   And insert the block.                                                 
 ; 
           (cond ((and (= len 3) (= dirr "l"))
                  (command "insert" "shield3" pa (- bscal) bscal 0))
                 ((and (= len 3) (= dirr "r"))
                  (command "insert" "shield3" pa bscal bscal 0))
                 ((= dirr "l")
                  (command "insert" "shield2" pa (- bscal) bscal 0))
                 ((= dirr "r")
                  (command "insert" "shield2" pa bscal bscal 0))))
 ; Ŀ
 ;   If there is no nearby terminal block.                                 
 ; 
      (progn
 ; Ŀ
 ;   Again, count the number of lines in the vicinity.                     
 ; 
           (setq p0 (polar pa (/ pi 2) 4))
           (setq p1 (polar p0 (/ pi 2) 12))
           (if (setq ss (ssget "c" p0 p1 '((-4 . "<or") (0 . "polyline")
                                (0 . "lwpolyline") (0 . "line") (-4 . "or>"))))
               (setq len (sslength ss)))
 ; Ŀ
 ;   And insert the block.                                                 
 ; 
           (if (= len 3)
               (command "insert" "shieldcut3" pa (misps) "" 0)
               (command "insert" "shieldcut2" pa (misps) "" 0))))
 ; Ŀ
 ;   Make the block green.                                                 
 ; 
  (setq enam (entlast))
  (if (= (strcase (substr (cdr (assoc 2 (entget enam))) 1 6) t) "shield")
      (command ".change" enam "" "p" "color" "green" ""))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* nil)
 (princ))